import pandas as pd  
import pickle 
from decision_company import read_csv_file, fetch_column, logical_and, filter_by_condition, count_rows

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  

# Create conditions  
condition1 = fetch_column(high_credit_long_duration, 'age') >= 25  
condition2 = fetch_column(high_credit_long_duration, 'age') <= 55  
  
# Perform logical AND operation  
final_condition = logical_and(condition1, condition2)  
  
# Filter the clients aged between 25 and 55  
clients_25_to_55 = filter_by_condition(high_credit_long_duration, final_condition)  
  
# Calculate the count of clients aged between 25 and 55  
result_count = count_rows(clients_25_to_55)  
    
print(result_count)  
pickle.dump(result_count,open("./ref_result/result_count_1.pkl","wb"))